"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLangsmithTracer = void 0;
var _langsmith = require("langsmith");
var _tracer_langchain = require("@langchain/core/tracers/tracer_langchain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLangsmithTracer = config => {
  return new _tracer_langchain.LangChainTracer({
    projectName: config.project,
    client: new _langsmith.Client({
      apiKey: config.apiKey,
      apiUrl: config.apiUrl
    })
  });
};
exports.getLangsmithTracer = getLangsmithTracer;