"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processSearchResults = exports.processRatings = exports.parseRatings = exports.extractToolResults = void 0;
var _messages = require("@langchain/core/messages");
var _wciServer = require("@kbn/wci-server");
var _from_langchain_messages = require("../../../utils/from_langchain_messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extract the tool results from all tool messages from the provided list of messages
 */
const extractToolResults = messages => {
  return messages.filter(_messages.isToolMessage).map(message => ({
    toolCallId: message.tool_call_id,
    result: (0, _from_langchain_messages.extractTextContent)(message)
  }));
};
exports.extractToolResults = extractToolResults;
const processSearchResults = messages => {
  const toolResults = extractToolResults(messages);
  const results = [];
  const unknownResults = [];
  toolResults.forEach(({
    result
  }) => {
    const parsed = JSON.parse(result);
    if (parsed.content && Array.isArray(parsed.content)) {
      parsed.content.forEach(content => {
        if ((0, _wciServer.isContentResultTransportFormat)(content)) {
          const parsedContent = {
            reference: content.reference,
            content: JSON.parse(content.text)
          };
          results.push(parsedContent);
        } else {
          unknownResults.push(content);
        }
      });
    }
  });
  return {
    results,
    unknownResults
  };
};
exports.processSearchResults = processSearchResults;
const parseRatings = rawRatings => {
  return rawRatings.map(rating => {
    const parts = rating.split('|');
    return {
      id: parts[0],
      score: parseInt(parts[1], 10)
    };
  });
};
exports.parseRatings = parseRatings;
const processRatings = ({
  results,
  ratings,
  maxResults,
  minScore
}) => {
  const resultsWithRatings = results.map((result, index) => {
    var _rating$score;
    const rating = ratings.find(r => r.id === `${index}`);
    return {
      result,
      score: (_rating$score = rating === null || rating === void 0 ? void 0 : rating.score) !== null && _rating$score !== void 0 ? _rating$score : 0
    };
  });

  // TODO: handle maxResults
  return resultsWithRatings.filter(result => result.score >= minScore).map(result => result.result);
};
exports.processRatings = processRatings;