"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listClientsTools = void 0;
var _wciCommon = require("@kbn/wci-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve all the tools from a list of MCP clients.
 */
const listClientsTools = async ({
  clients,
  logger
}) => {
  const clientsTools = await Promise.all(Object.entries(clients).map(async ([clientId, client]) => {
    try {
      var _toolsResponse$tools;
      const toolsResponse = await client.listTools();
      if (toolsResponse !== null && toolsResponse !== void 0 && (_toolsResponse$tools = toolsResponse.tools) !== null && _toolsResponse$tools !== void 0 && _toolsResponse$tools.length) {
        return toolsResponse.tools.map(tool => ({
          name: (0, _wciCommon.buildToolName)({
            integrationId: clientId,
            toolName: tool.name
          }),
          description: tool.description || '',
          inputSchema: tool.inputSchema || {}
        }));
      }
      return [];
    } catch (err) {
      logger === null || logger === void 0 ? void 0 : logger.warn(`Error fetching tools for client: ${clientId}`);
      return [];
    }
  }));
  return clientsTools.flat();
};
exports.listClientsTools = listClientsTools;