"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEventsConverter = void 0;
var _converters = require("./converters");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Build the event converter based on the agent graph definition.
 *
 * Note: this is totally static for now, but will become dynamic once we introduce assistant
 * configuration / workflow builder functionalities.
 */
const buildEventsConverter = () => {
  const converters = [];

  // main graph converter
  converters.push((0, _converters.getSimpleGraphConverter)({
    graphName: _constants.graphNames.mainAgent
  }));

  // search agent converter
  converters.push((0, _converters.getSearchAgentGraphConverter)({
    graphName: _constants.graphNames.searchAgent
  }));
  return function graphEventConverter(event) {
    for (const converter of converters) {
      if (converter.handleEvent(event)) {
        return converter.convert(event);
      }
    }
    return [];
  };
};
exports.buildEventsConverter = buildEventsConverter;