"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _agent_runner = require("./agent_runner");
var _mcp_gateway = require("./mcp_gateway");
var _base_tools = require("./base_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentFactory {
  constructor({
    inference,
    logger,
    integrationsService,
    agentService,
    tracingConfig
  }) {
    (0, _defineProperty2.default)(this, "inference", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "agentService", void 0);
    (0, _defineProperty2.default)(this, "integrationsService", void 0);
    (0, _defineProperty2.default)(this, "tracingConfig", void 0);
    this.inference = inference;
    this.logger = logger;
    this.integrationsService = integrationsService;
    this.agentService = agentService;
    this.tracingConfig = tracingConfig;
  }
  async getAgentRunner({
    request,
    connectorId,
    agentId
  }) {
    this.logger.debug(`getAgent [agentId=${agentId}] [connectorId=${connectorId}]`);
    const createSession = async () => {
      return await this.createGatewaySession({
        request
      });
    };
    const agentClient = await this.agentService.getScopedClient({
      request
    });
    const agent = await agentClient.get({
      agentId
    });
    const chatModel = await this.inference.getChatModel({
      request,
      connectorId,
      chatModelOptions: {}
    });
    return await (0, _agent_runner.createAgentRunner)({
      agent,
      chatModel,
      createSession,
      logger: this.logger.get('runner'),
      tracingConfig: this.tracingConfig
    });
  }
  async createGatewaySession({
    request
  }) {
    const integrationProviders = await this.integrationsService.getIntegrationProviders({
      integrationIds: '*',
      request
    });
    const additionalProviders = [await (0, _base_tools.getBaseToolProvider)()];
    return new _mcp_gateway.McpGatewaySessionImpl({
      providers: [...integrationProviders, ...additionalProviders],
      logger: this.logger.get('session')
    });
  }
}
exports.AgentFactory = AgentFactory;