"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _integrations = require("../../saved_objects/integrations");
var _integration_client = require("./integration_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IntegrationsServiceImpl {
  constructor({
    logger,
    registry,
    savedObjects,
    security
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "registry", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    this.logger = logger;
    this.registry = registry;
    this.savedObjects = savedObjects;
    this.security = security;
  }
  async getScopedClient({
    request
  }) {
    const user = this.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('No user bound to the provided request');
    }
    const soClient = this.savedObjects.getScopedClient(request, {
      includedHiddenTypes: [_integrations.integrationTypeName]
    });
    return new _integration_client.IntegrationClientImpl({
      logger: this.logger.get('client'),
      client: soClient,
      user: {
        id: user.profile_uid,
        username: user.username
      }
    });
  }
  async getIntegrationProviders({
    integrationIds,
    request
  }) {
    const client = await this.getScopedClient({
      request
    });
    let integrations = [];
    if (typeof integrationIds === 'string') {
      integrations = await client.list();
    } else {
      for (const integrationId of integrationIds) {
        // TODO: bulk get on client
        integrations.push(await client.get({
          integrationId
        }));
      }
    }
    return await Promise.all(integrations.map(async source => {
      return integrationToProvider({
        integration: source,
        request,
        registry: this.registry
      });
    }));
  }
}
exports.IntegrationsServiceImpl = IntegrationsServiceImpl;
const integrationToProvider = async ({
  integration,
  registry,
  request
}) => {
  const definition = registry.get(integration.type);
  const instance = await definition.createIntegration({
    request,
    integrationId: integration.id,
    configuration: integration.configuration,
    description: integration.description
  });
  return {
    id: integration.id,
    connect: instance.connect,
    meta: {}
  };
};