"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IntegrationRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "allowRegistration", true);
    (0, _defineProperty2.default)(this, "integrationTypes", new Map());
  }
  register(definition) {
    if (!this.allowRegistration) {
      throw new Error(`Tried to register tool but allowRegistration is false`);
    }
    if (this.has(definition.getType())) {
      throw new Error(`Tried to register Tool [${definition.getType()}], but already registered`);
    }
    this.integrationTypes.set(definition.getType(), definition);
  }
  blockRegistration() {
    this.allowRegistration = false;
  }
  has(type) {
    return this.integrationTypes.has(type);
  }
  get(type) {
    if (!this.has(type)) {
      throw new Error(`Tool definition for type [${type}] not found`);
    }
    return this.integrationTypes.get(type);
  }
  getAll() {
    return [...this.integrationTypes.values()];
  }
}
exports.IntegrationRegistry = IntegrationRegistry;