"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationClientImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _integrations = require("../../saved_objects/integrations");
var _convert_model = require("./convert_model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IntegrationClientImpl {
  constructor({
    client,
    user,
    logger
  }) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "user", void 0);
    // @ts-ignore will be used later
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.client = client;
    this.user = user;
    this.logger = logger;
  }
  async list() {
    const {
      saved_objects: results
    } = await this.client.find({
      type: _integrations.integrationTypeName,
      perPage: 1000
    });
    return results.map(_convert_model.savedObjectToModel);
  }
  async get({
    integrationId
  }) {
    const integrationSo = await this._rawGet({
      integrationId
    });
    return (0, _convert_model.savedObjectToModel)(integrationSo);
  }
  async create(integration) {
    var _integration$id;
    const now = new Date();
    const id = (_integration$id = integration.id) !== null && _integration$id !== void 0 ? _integration$id : (0, _uuid.v4)();
    const attributes = (0, _convert_model.createRequestToRaw)({
      integration,
      id,
      user: this.user,
      creationDate: now
    });
    const created = await this.client.create(_integrations.integrationTypeName, attributes, {
      id
    });
    return (0, _convert_model.savedObjectToModel)(created);
  }
  async update(integrationId, updatedFields) {
    const integrationSo = await this._rawGet({
      integrationId
    });
    const updatedAttributes = {
      ...integrationSo.attributes,
      ...(0, _convert_model.updateToAttributes)({
        updatedFields
      })
    };
    await this.client.update(_integrations.integrationTypeName, integrationSo.id, updatedAttributes);
    return (0, _convert_model.savedObjectToModel)({
      ...integrationSo,
      attributes: updatedAttributes
    });
  }
  async delete(integrationId) {
    const integrationSo = await this._rawGet({
      integrationId
    });
    await this.client.delete(_integrations.integrationTypeName, integrationSo.id);
  }
  async _rawGet({
    integrationId
  }) {
    const {
      saved_objects: results
    } = await this.client.find({
      type: _integrations.integrationTypeName,
      filter: `${_integrations.integrationTypeName}.attributes.integration_id: ${integrationId}`
    });
    if (results.length > 0) {
      return results[0];
    }
    throw new Error(`Integration ${integrationId} not found`);
  }
}
exports.IntegrationClientImpl = IntegrationClientImpl;