"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _chat = require("./chat");
var _conversation = require("./conversation");
var _connectors = require("./connectors");
var _integrations = require("./integrations");
var _agents = require("./agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = dependencies => {
  (0, _chat.registerChatRoutes)(dependencies);
  (0, _conversation.registerConversationRoutes)(dependencies);
  (0, _connectors.registerConnectorRoutes)(dependencies);
  (0, _agents.registerAgentRoutes)(dependencies);
  (0, _integrations.registerIntegrationsRoutes)(dependencies);
};
exports.registerRoutes = registerRoutes;