"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorRoutes = void 0;
var _wcGenaiUtils = require("@kbn/wc-genai-utils");
var _features = require("../../common/features");
var _wrap_handler = require("./wrap_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerConnectorRoutes = ({
  logger,
  router,
  core
}) => {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  router.get({
    path: '/internal/workchat/connectors',
    security: {
      authz: {
        requiredPrivileges: [_features.apiCapabilities.useWorkchat]
      }
    },
    validate: false
  }, wrapHandler(async (ctx, request, res) => {
    const [, startDeps] = await core.getStartServices();
    const {
      actions
    } = startDeps;
    const connectors = await (0, _wcGenaiUtils.getConnectorList)({
      request,
      actions
    });
    return res.ok({
      body: {
        connectors
      }
    });
  }));
};
exports.registerConnectorRoutes = registerConnectorRoutes;