"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConversationService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  async list(request) {
    const response = await this.http.post('/internal/workchat/conversations', {
      body: JSON.stringify(request)
    });
    return response.conversations;
  }
  async get(conversationId) {
    return await this.http.get(`/internal/workchat/conversations/${conversationId}`);
  }
}
exports.ConversationService = ConversationService;