"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  async list() {
    const response = await this.http.get('/internal/workchat/agents');
    return response.agents;
  }
  async get(agentId) {
    return await this.http.get(`/internal/workchat/agents/${agentId}`);
  }
  async create(request) {
    return await this.http.post(`/internal/workchat/agents`, {
      body: JSON.stringify(request)
    });
  }
  async update(id, request) {
    return await this.http.put(`/internal/workchat/agents/${id}`, {
      body: JSON.stringify(request)
    });
  }
}
exports.AgentService = AgentService;