"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _application = require("./application");
var _services = require("./services");
var _integration_service = require("./services/integration/integration_service");
var _integration_registry = require("./services/integration/integration_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WorkChatAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "integrationRegistry", new _integration_registry.IntegrationRegistry());
  }
  setup(core) {
    (0, _application.registerApp)({
      core,
      getServices: () => {
        if (!this.services) {
          throw new Error('getServices called before plugin start');
        }
        return this.services;
      }
    });
    return {
      integrations: {
        register: integrationComponents => {
          this.integrationRegistry.register(integrationComponents);
        }
      }
    };
  }
  start({
    http
  }, pluginsStart) {
    const conversationService = new _services.ConversationService({
      http
    });
    const chatService = new _services.ChatService({
      http
    });
    const agentService = new _services.AgentService({
      http
    });
    const integrationService = new _integration_service.IntegrationService({
      http
    });
    this.services = {
      chatService,
      agentService,
      conversationService,
      integrationService,
      integrationRegistry: this.integrationRegistry
    };
    return {};
  }
  stop() {}
}
exports.WorkChatAppPlugin = WorkChatAppPlugin;