"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkChatServices = void 0;
var _react = require("react");
var _workchat_services_context = require("../context/workchat_services_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWorkChatServices = () => {
  const services = (0, _react.useContext)(_workchat_services_context.WorkChatServicesContext);
  if (services === undefined) {
    throw new Error(`WorkChatServicesContext not set. Did you wrap your component in <WorkChatServicesContext.Provider> ?`);
  }
  return services;
};
exports.useWorkChatServices = useWorkChatServices;