"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithFadeIn = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fadeIn = (0, _react2.keyframes)`
  from {
    opacity: 0.6;
  }
  to {
    opacity: 1;
  }
`;
const fadeInStyle = (0, _react2.css)`
  ${_eui.euiCanAnimate} {
    animation: ${fadeIn} 0.6s ease-in forwards;
  }
`;
const WithFadeIn = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: fadeInStyle
  }, children);
};
exports.WithFadeIn = WithFadeIn;