"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIntegrationDisabled = exports.integrationTypeToLabel = exports.getIntegrationIcon = void 0;
var _wciCommon = require("@kbn/wci-common");
var _salesforce = _interopRequireDefault(require("../../../assets/salesforce.svg"));
var _google_drive = _interopRequireDefault(require("../../../assets/google_drive.svg"));
var _sharepoint = _interopRequireDefault(require("../../../assets/sharepoint.svg"));
var _slack = _interopRequireDefault(require("../../../assets/slack.svg"));
var _confluence = _interopRequireDefault(require("../../../assets/confluence.svg"));
var _jira = _interopRequireDefault(require("../../../assets/jira.svg"));
var _github = _interopRequireDefault(require("../../../assets/github.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationTypeToLabel = type => {
  switch (type) {
    case _wciCommon.IntegrationType.index_source:
      return 'Index Source';
    case _wciCommon.IntegrationType.external_server:
      return 'External Server';
    case _wciCommon.IntegrationType.salesforce:
      return 'Salesforce';
    case _wciCommon.IntegrationType.google_drive:
      return 'Google Drive';
    case _wciCommon.IntegrationType.sharepoint:
      return 'Sharepoint';
    case _wciCommon.IntegrationType.slack:
      return 'Slack';
    case _wciCommon.IntegrationType.confluence:
      return 'Confluence';
    case _wciCommon.IntegrationType.jira:
      return 'Jira';
    case _wciCommon.IntegrationType.github:
      return 'Github';
    default:
      return type;
  }
};
exports.integrationTypeToLabel = integrationTypeToLabel;
const getIntegrationIcon = type => {
  switch (type) {
    case _wciCommon.IntegrationType.salesforce:
      return _salesforce.default;
    case _wciCommon.IntegrationType.index_source:
      return 'index';
    case _wciCommon.IntegrationType.external_server:
      return 'database';
    case _wciCommon.IntegrationType.google_drive:
      return _google_drive.default;
    case _wciCommon.IntegrationType.sharepoint:
      return _sharepoint.default;
    case _wciCommon.IntegrationType.slack:
      return _slack.default;
    case _wciCommon.IntegrationType.confluence:
      return _confluence.default;
    case _wciCommon.IntegrationType.jira:
      return _jira.default;
    case _wciCommon.IntegrationType.github:
      return _github.default;
    default:
      return '';
  }
};
exports.getIntegrationIcon = getIntegrationIcon;
const isIntegrationDisabled = type => {
  switch (type) {
    case _wciCommon.IntegrationType.google_drive:
    case _wciCommon.IntegrationType.sharepoint:
    case _wciCommon.IntegrationType.slack:
    case _wciCommon.IntegrationType.confluence:
    case _wciCommon.IntegrationType.jira:
    case _wciCommon.IntegrationType.github:
      return true;
    default:
      return false;
  }
};
exports.isIntegrationDisabled = isIntegrationDisabled;