"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolLabels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolLabels = exports.toolLabels = {
  breadcrumb: {
    toolsPill: _i18n.i18n.translate('workchatApp.integrations.breadcrumb.tools', {
      defaultMessage: 'Tools'
    }),
    editToolPill: _i18n.i18n.translate('workchatApp.integrations.breadcrumb.editTool', {
      defaultMessage: 'Edit tool'
    }),
    createToolPill: _i18n.i18n.translate('workchatApp.integrations.breadcrumb.createTool', {
      defaultMessage: 'Create tool'
    })
  },
  notifications: {
    toolCreatedToastText: _i18n.i18n.translate('workchatApp.integrations.notifications.toolCreatedToastText', {
      defaultMessage: 'Tool created'
    }),
    toolUpdatedToastText: _i18n.i18n.translate('workchatApp.integrations.notifications.toolUpdatedToastText', {
      defaultMessage: 'Tool updated'
    }),
    toolDeletedToastText: _i18n.i18n.translate('workchatApp.integrations.notifications.toolDeletedToastText', {
      defaultMessage: 'Tool successfully deleted'
    })
  },
  editView: {
    createToolTitle: _i18n.i18n.translate('workchatApp.integrations.editView.createTitle', {
      defaultMessage: 'Create a new tool'
    }),
    editToolTitle: _i18n.i18n.translate('workchatApp.integrations.editView.editTitle', {
      defaultMessage: 'Edit tool'
    }),
    cancelButtonLabel: _i18n.i18n.translate('workchatApp.integrations.editView.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    saveButtonLabel: _i18n.i18n.translate('workchatApp.integrations.editView.saveButtonLabel', {
      defaultMessage: 'Save'
    }),
    deleteButtonLabel: _i18n.i18n.translate('workchatApp.integrations.editView.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }),
    baseConfigurationTitle: _i18n.i18n.translate('workchatApp.integrations.editView.baseConfigurationTitle', {
      defaultMessage: 'Base configuration'
    }),
    baseConfigurationDescription: _i18n.i18n.translate('workchatApp.integrations.editView.baseConfigurationDescription', {
      defaultMessage: 'Configure your tool'
    }),
    nameLabel: _i18n.i18n.translate('workchatApp.integrations.editView.nameLabel', {
      defaultMessage: 'Name'
    }),
    nameRequired: _i18n.i18n.translate('workchatApp.integrations.editView.nameRequired', {
      defaultMessage: 'Name is required'
    }),
    descriptionLabel: _i18n.i18n.translate('workchatApp.integrations.editView.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    descriptionRequired: _i18n.i18n.translate('workchatApp.integrations.editView.descriptionRequired', {
      defaultMessage: 'Description is required'
    }),
    typeLabel: _i18n.i18n.translate('workchatApp.integrations.editView.typeLabel', {
      defaultMessage: 'Type'
    }),
    deleteModalTitle: _i18n.i18n.translate('workchatApp.integrations.editView.deleteModalTitle', {
      defaultMessage: 'Delete tool'
    })
  },
  listView: {
    addToolLabel: _i18n.i18n.translate('workchatApp.integrations.listView.addTool', {
      defaultMessage: 'Add tool'
    }),
    browseToolLabel: _i18n.i18n.translate('workchatApp.integrations.listView.browseTool', {
      defaultMessage: 'Browse tools'
    })
  }
};