"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationEditView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _wciCommon = require("@kbn/wci-common");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../../hooks/use_navigation");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_breadcrumbs = require("../../../hooks/use_breadcrumbs");
var _use_integration_edit = require("../../../hooks/use_integration_edit");
var _use_integration_delete = require("../../../hooks/use_integration_delete");
var _use_integration_configuration_form = require("../../../hooks/use_integration_configuration_form");
var _app_paths = require("../../../app_paths");
var _i18n2 = require("../i18n");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationEditView = ({
  integrationId
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const breadcrumb = (0, _react.useMemo)(() => {
    return [{
      text: _i18n2.toolLabels.breadcrumb.toolsPill,
      path: _app_paths.appPaths.tools.list
    }, integrationId ? {
      text: _i18n2.toolLabels.editView.editToolTitle
    } : {
      text: _i18n2.toolLabels.editView.createToolTitle
    }];
  }, [integrationId]);
  (0, _use_breadcrumbs.useBreadcrumb)(breadcrumb);
  const handleCancel = (0, _react.useCallback)(() => {
    navigateToWorkchatUrl(_app_paths.appPaths.tools.catalog);
  }, [navigateToWorkchatUrl]);
  const onSaveSuccess = (0, _react.useCallback)(() => {
    notifications.toasts.addSuccess(integrationId ? _i18n2.toolLabels.notifications.toolUpdatedToastText : _i18n2.toolLabels.notifications.toolCreatedToastText);
    navigateToWorkchatUrl(_app_paths.appPaths.tools.list);
  }, [integrationId, navigateToWorkchatUrl, notifications]);
  const onSaveError = (0, _react.useCallback)(err => {
    notifications.toasts.addError(err, {
      title: 'Error'
    });
  }, [notifications]);
  const {
    state,
    submit
  } = (0, _use_integration_edit.useIntegrationEdit)({
    integrationId,
    onSaveSuccess,
    onSaveError
  });
  const integrationTypes = [{
    value: '',
    text: 'Pick a type'
  }, ...Object.values(_wciCommon.IntegrationType).filter(type => !(0, _utils.isIntegrationDisabled)(type)).map(type => ({
    value: type,
    text: (0, _utils.integrationTypeToLabel)(type)
  }))];
  const onDeleteSuccess = (0, _react.useCallback)(() => {
    notifications.toasts.addSuccess(_i18n2.toolLabels.notifications.toolDeletedToastText);
    navigateToWorkchatUrl(_app_paths.appPaths.tools.list);
  }, [navigateToWorkchatUrl, notifications]);
  const onDeleteError = (0, _react.useCallback)(err => {
    notifications.toasts.addError(err, {
      title: 'Error deleting tool'
    });
  }, [notifications]);
  const {
    deleteIntegration,
    isDeleting
  } = (0, _use_integration_delete.useIntegrationDelete)({
    onDeleteSuccess,
    onDeleteError
  });
  const handleDelete = (0, _react.useCallback)(() => {
    if (integrationId) {
      deleteIntegration(integrationId);
    }
    setIsDeleteModalVisible(false);
  }, [deleteIntegration, integrationId]);
  const showDeleteModal = () => {
    setIsDeleteModalVisible(true);
  };
  const closeDeleteModal = () => {
    setIsDeleteModalVisible(false);
  };
  const params = new URLSearchParams(location.search);
  const type = params.get('type');
  const formMethods = (0, _reactHookForm.useForm)({
    values: {
      ...state,
      type: type || state.type
    }
  });
  const {
    handleSubmit,
    formState: {
      isSubmitting
    },
    control,
    watch
  } = formMethods;
  const ConfigurationForm = (0, _use_integration_configuration_form.useIntegrationConfigurationForm)(watch('type'));
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    panelled: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: integrationId ? _i18n2.toolLabels.editView.editToolTitle : _i18n2.toolLabels.editView.createToolTitle
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, formMethods, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: handleSubmit(data => submit(data))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n2.toolLabels.editView.baseConfigurationTitle),
    description: _i18n2.toolLabels.editView.baseConfigurationDescription
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.toolLabels.editView.nameLabel,
    isInvalid: !!formMethods.formState.errors.name,
    error: formMethods.formState.errors.name ? _i18n2.toolLabels.editView.nameRequired : undefined
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    rules: {
      required: _i18n2.toolLabels.editView.nameRequired
    },
    name: "name",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewFieldText",
      isInvalid: !!formMethods.formState.errors.name
    }, field))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.toolLabels.editView.descriptionLabel,
    isInvalid: !!formMethods.formState.errors.description,
    error: formMethods.formState.errors.description ? _i18n2.toolLabels.editView.descriptionRequired : undefined
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    rules: {
      required: _i18n2.toolLabels.editView.descriptionRequired
    },
    name: "description",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewFieldText",
      rows: 3,
      isInvalid: !!formMethods.formState.errors.description
    }, field))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.toolLabels.editView.typeLabel
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "type",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewSelect",
      options: integrationTypes
    }, field, {
      disabled: !!integrationId
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ConfigurationForm && /*#__PURE__*/_react.default.createElement(ConfigurationForm, {
    form: formMethods
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "workchatAppIntegrationEditViewCancelButton",
    type: "button",
    iconType: "framePrevious",
    color: "warning",
    onClick: handleCancel
  }, _i18n2.toolLabels.editView.cancelButtonLabel)), integrationId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "workchatAppIntegrationEditViewDeleteButton",
    color: "danger",
    onClick: showDeleteModal,
    isLoading: isDeleting
  }, "Delete")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "workchatAppIntegrationEditViewSaveButton",
    type: "submit",
    iconType: "save",
    fill: true,
    disabled: isSubmitting
  }, _i18n2.toolLabels.editView.saveButtonLabel)))), isDeleteModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n2.toolLabels.editView.deleteModalTitle,
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: closeDeleteModal,
    onConfirm: handleDelete,
    cancelButtonText: _i18n2.toolLabels.editView.cancelButtonLabel,
    confirmButtonText: _i18n2.toolLabels.editView.deleteButtonLabel,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('workchatApp.integrations.editView.deleteMessage', {
    defaultMessage: 'Are you sure you want to delete this tool? This action cannot be undone.'
  })))))));
};
exports.IntegrationEditView = IntegrationEditView;