"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeConversationHistorySection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../hooks/use_navigation");
var _use_agent_list = require("../../hooks/use_agent_list");
var _use_conversation_list = require("../../hooks/use_conversation_list");
var _sort_and_group_conversations = require("../../utils/sort_and_group_conversations");
var _slice_recent_conversations = require("../../utils/slice_recent_conversations");
var _app_paths = require("../../app_paths");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOMEPAGE_CONVERSATION_HISTORY_LIMIT = 5;
const HomeConversationHistorySection = () => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    agents,
    isLoading: isAgentsLoading
  } = (0, _use_agent_list.useAgentList)();
  const {
    conversations,
    isLoading: isConversationHistoryLoading
  } = (0, _use_conversation_list.useConversationList)({});
  const agentMap = (0, _react.useMemo)(() => {
    return agents.reduce((map, agent) => {
      map[agent.id] = agent;
      return map;
    }, {});
  }, [agents]);
  const conversationGroups = (0, _react.useMemo)(() => {
    return (0, _sort_and_group_conversations.sortAndGroupConversations)((0, _slice_recent_conversations.sliceRecentConversations)(conversations, HOMEPAGE_CONVERSATION_HISTORY_LIMIT));
  }, [conversations]);
  if (isAgentsLoading || isConversationHistoryLoading) {
    return;
  }
  const recentConversations = conversationGroups.map(({
    dateLabel,
    conversations: groupConversations
  }) => {
    const conversationItems = groupConversations.map(conversation => {
      const agent = agentMap[conversation.agentId];
      if (!agent) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        key: conversation.id,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
          name: agent.name,
          initials: agent.avatar.text,
          color: agent.avatar.color,
          size: "s"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          direction: "column",
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s"
        }, conversation.title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, agent.name))),
        onClick: () => {
          navigateToWorkchatUrl(_app_paths.appPaths.chat.conversation({
            agentId: agent.id,
            conversationId: conversation.id
          }));
        },
        size: "s"
      });
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: dateLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      color: "transparent",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, dateLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      flush: true,
      maxWidth: false,
      gutterSize: "s"
    }, conversationItems), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "list",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.home.recentConversations.title', {
    defaultMessage: 'Recent conversations'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, recentConversations));
};
exports.HomeConversationHistorySection = HomeConversationHistorySection;