"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatHeaderSettingsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_connectors = require("../../../hooks/use_connectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatHeaderSettingsPanel = ({
  connectorId,
  onConnectorChange
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    connectors
  } = (0, _use_connectors.useConnectors)();
  const contextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'menuPopover'
  });
  const [lastSelectedConnectorId, setLastSelectedConnectorId] = (0, _useLocalStorage.default)('workchat.lastSelectedConnectorId');
  (0, _react.useEffect)(() => {
    if (connectors.length && !connectorId) {
      onConnectorChange(lastSelectedConnectorId !== null && lastSelectedConnectorId !== void 0 ? lastSelectedConnectorId : connectors[0].connectorId);
    }
  }, [connectorId, connectors, onConnectorChange, lastSelectedConnectorId]);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    display: "base",
    size: "m",
    iconType: "controlsHorizontal",
    iconSize: "m",
    onClick: onButtonClick
  });
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      title: _i18n.i18n.translate('workchatApp.chat.headerBar.connectorList.connectorsLabel', {
        defaultMessage: 'Connectors'
      }),
      items: connectors.map(connector => {
        return {
          name: connector.name,
          icon: connector.connectorId === connectorId ? 'check' : 'empty',
          onClick: () => {
            onConnectorChange(connector.connectorId);
            setLastSelectedConnectorId(connector.connectorId);
          }
        };
      })
    }];
  }, [connectors, connectorId, onConnectorChange, setLastSelectedConnectorId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: contextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.ChatHeaderSettingsPanel = ChatHeaderSettingsPanel;