"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_conversation = require("../../../hooks/use_conversation");
var _i18n = require("../i18n");
var _chat_header_settings_panel = require("./chat_header_settings_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatHeader = ({
  conversationId,
  connectorId,
  onConnectorChange
}) => {
  var _conversation$title;
  const {
    conversation,
    isLoading: isConvLoading
  } = (0, _use_conversation.useConversation)({
    conversationId
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const containerClass = (0, _css.css)`
    padding: ${euiTheme.size.s} ${euiTheme.size.m};
    border-bottom: solid ${euiTheme.border.width.thin} ${euiTheme.border.color};
  `;
  const conversationTitleClass = (0, _css.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
    font-size: ${(0, _eui.useEuiFontSize)('m').fontSize};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    borderRadius: "none",
    color: "subdued",
    className: containerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    isLoading: conversationId !== undefined && isConvLoading
  }, /*#__PURE__*/_react.default.createElement("h3", {
    className: conversationTitleClass
  }, (_conversation$title = conversation === null || conversation === void 0 ? void 0 : conversation.title) !== null && _conversation$title !== void 0 ? _conversation$title : _i18n.chatCommonLabels.newConversationLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chat_header_settings_panel.ChatHeaderSettingsPanel, {
    connectorId: connectorId,
    onConnectorChange: onConnectorChange
  })))));
};
exports.ChatHeader = ChatHeader;