"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sort_and_group_conversations = require("../../../utils/sort_and_group_conversations");
var _assistant_block = require("./assistant_block");
var _conversation_group = require("./conversation_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConversationPanel = ({
  agentId,
  conversations,
  activeConversationId,
  onConversationSelect,
  onNewConversationSelect
}) => {
  const handleConversationClick = (0, _react.useCallback)((event, conversationId) => {
    if (onConversationSelect) {
      event.preventDefault();
      onConversationSelect(conversationId);
    }
  }, [onConversationSelect]);
  const theme = (0, _eui.useEuiTheme)();
  const scrollBarStyles = (0, _eui.euiScrollBarStyles)(theme);
  const containerClassName = (0, _css.css)`
    height: 100%;
    width: 100%;
  `;
  const titleClassName = (0, _css.css)`
    text-transform: capitalize;
    font-weight: ${theme.euiTheme.font.weight.bold};
  `;
  const pageSectionContentClassName = (0, _css.css)`
    width: 100%;
    display: flex;
    flex-grow: 1;
    height: 100%;
    max-block-size: calc(100vh - var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0)));
    background-color: ${theme.euiTheme.colors.backgroundBasePlain};
    padding: ${theme.euiTheme.size.base} 0;
  `;
  const sectionBlockPaddingCLassName = (0, _css.css)`
    padding: 0 ${theme.euiTheme.size.base};
  `;
  const scrollContainerClassName = (0, _css.css)`
    overflow-y: auto;
    padding: 0 ${theme.euiTheme.size.base};
    ${scrollBarStyles}
  `;
  const createButtonRuleClassName = (0, _css.css)`
    margin-bottom: ${theme.euiTheme.size.base};
  `;
  const conversationGroups = (0, _react.useMemo)(() => {
    return (0, _sort_and_group_conversations.sortAndGroupConversations)(conversations);
  }, [conversations]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    color: "transparent",
    className: pageSectionContentClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: containerClassName,
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: sectionBlockPaddingCLassName
  }, /*#__PURE__*/_react.default.createElement(_assistant_block.AssistantBlock, {
    agentId: agentId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: sectionBlockPaddingCLassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "list"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: titleClassName
  }, _i18n.i18n.translate('xpack.workchatApp.conversationList.conversationTitle', {
    defaultMessage: 'Conversations'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: scrollContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: containerClassName,
    gutterSize: "none",
    responsive: false
  }, conversationGroups.map(({
    conversations: groupConversations,
    dateLabel
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_conversation_group.ConversationGroup, {
    key: dateLabel,
    conversations: groupConversations,
    dateLabel: dateLabel,
    activeConversationId: activeConversationId,
    onConversationClick: handleConversationClick
  }), index < conversationGroups.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    key: dateLabel + '-spacer',
    size: "m"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full",
    margin: "none",
    className: createButtonRuleClassName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: sectionBlockPaddingCLassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "newChat",
    onClick: () => onNewConversationSelect && onNewConversationSelect()
  }, _i18n.i18n.translate('xpack.workchatApp.newConversationButtonLabel', {
    defaultMessage: 'New conversation'
  })))));
};
exports.ConversationPanel = ConversationPanel;