"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatConversationProgression = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fancy_loading_text = require("../../utilities/fancy_loading_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatConversationProgression = ({
  progressionEvents
}) => {
  if (progressionEvents.length === 0) {
    return undefined;
  }
  const getText = event => {
    switch (event.data.step) {
      case 'planning':
        return 'Thinking about which tools to use';
      case 'retrieval':
        return 'Calling relevant tools';
      case 'analysis':
        return 'Analysing the results';
      case 'generate_summary':
        return 'Summarizing content';
      default:
        return 'Working';
    }
  };
  const lastEvent = progressionEvents[progressionEvents.length - 1];
  const icon = /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: "loading",
    color: "plain",
    iconType: _eui.EuiLoadingElastic
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTimelineItem, {
    icon: icon
  }, /*#__PURE__*/_react.default.createElement(_fancy_loading_text.FancyLoadingText, {
    text: getText(lastEvent)
  }));
};
exports.ChatConversationProgression = ChatConversationProgression;