"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatNewConversationPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_agent = require("../../hooks/use_agent");
var _i18n = require("./i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatNewConversationPrompt = ({
  agentId,
  onSubmit
}) => {
  var _agent$name, _agent$avatar, _agent$avatar2;
  const inputRef = (0, _react.useRef)(null);
  const [message, setMessage] = (0, _react.useState)('');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    agent
  } = (0, _use_agent.useAgent)({
    agentId
  });
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      var _inputRef$current;
      (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.focus();
    }, 200);
  }, [inputRef]);
  const containerClass = (0, _css.css)`
    width: 100%;
    max-width: 600px;
  `;
  const inputContainerClass = (0, _css.css)`
    padding-top: ${euiTheme.size.l};
    width: 100%;
  `;
  const agentNameClassName = (0, _css.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
  `;
  const inputFlexItemClass = (0, _css.css)`
    max-width: 900px;
  `;
  const handleSubmit = (0, _react.useCallback)(() => {
    if (!message.trim()) {
      return;
    }
    onSubmit(message);
    setMessage('');
  }, [message, onSubmit]);
  const handleChange = (0, _react.useCallback)(event => {
    setMessage(event.currentTarget.value);
  }, []);
  const handleTextAreaKeyDown = (0, _react.useCallback)(event => {
    if (!event.shiftKey && event.key === _eui.keys.ENTER) {
      event.preventDefault();
      handleSubmit();
    }
  }, [handleSubmit]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: containerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    borderRadius: "none",
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: (_agent$name = agent === null || agent === void 0 ? void 0 : agent.name) !== null && _agent$name !== void 0 ? _agent$name : _i18n.chatCommonLabels.assistant.defaultNameLabel,
    size: "xl",
    type: "user",
    initials: agent === null || agent === void 0 ? void 0 : (_agent$avatar = agent.avatar) === null || _agent$avatar === void 0 ? void 0 : _agent$avatar.text,
    color: agent === null || agent === void 0 ? void 0 : (_agent$avatar2 = agent.avatar) === null || _agent$avatar2 === void 0 ? void 0 : _agent$avatar2.color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    className: agentNameClassName
  }, agent === null || agent === void 0 ? void 0 : agent.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, agent === null || agent === void 0 ? void 0 : agent.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: inputContainerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: inputFlexItemClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    inputRef: inputRef,
    "data-test-subj": "workchatAppChatNewConvTextArea",
    fullWidth: true,
    rows: 1,
    resize: "vertical",
    value: message,
    onChange: handleChange,
    onKeyDown: handleTextAreaKeyDown,
    placeholder: _i18n.chatCommonLabels.userInputBox.placeholder
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "workchatAppChatNewConvSubmitButton",
    iconType: "kqlFunction",
    display: "fill",
    size: "m",
    onClick: handleSubmit
  }))))))));
  return;
};
exports.ChatNewConversationPrompt = ChatNewConversationPrompt;