"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantListView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../app_paths");
var _assistant_create_modal = require("../assistant_create_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantListView = ({
  agents
}) => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const [sortField, setSortField] = (0, _react.useState)('name');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [createModalOpen, setCreateModalOpen] = (0, _react.useState)(false);
  const columns = [{
    field: 'name',
    name: 'Name',
    sortable: true,
    render: (name, agent) => {
      var _agent$avatar, _agent$avatar2;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        size: "m",
        name: agent.name,
        initials: (_agent$avatar = agent.avatar) === null || _agent$avatar === void 0 ? void 0 : _agent$avatar.text,
        color: (_agent$avatar2 = agent.avatar) === null || _agent$avatar2 === void 0 ? void 0 : _agent$avatar2.color
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => navigateToWorkchatUrl(_app_paths.appPaths.assistants.edit({
          agentId: agent.id
        }))
      }, name));
    }
  }, {
    field: 'user.name',
    name: 'Created by'
  }, {
    field: 'public',
    name: 'Visibility'
  }, {
    name: 'Actions',
    actions: [{
      name: 'Edit',
      description: 'Edit this agent',
      isPrimary: true,
      icon: 'documentEdit',
      type: 'icon',
      onClick: ({
        id
      }) => {
        navigateToWorkchatUrl(_app_paths.appPaths.assistants.edit({
          agentId: id
        }));
      },
      'data-test-subj': 'agentListTable-edit-btn'
    }]
  }];
  const findAgents = (agentsList, currentPageIndex, currentPageSize, currentSortField, currentSortDirection) => {
    let items;
    if (currentSortField) {
      items = agentsList.slice(0).sort(_eui.Comparators.property(currentSortField, _eui.Comparators.default(currentSortDirection)));
    } else {
      items = agentsList;
    }
    let pageOfItems;
    if (!currentPageIndex && !currentPageSize) {
      pageOfItems = items;
    } else {
      const startIndex = currentPageIndex * currentPageSize;
      pageOfItems = items.slice(startIndex, Math.min(startIndex + currentPageSize, agentsList.length));
    }
    return {
      pageOfItems,
      totalItemCount: agentsList.length
    };
  };
  const headerButtons = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'plusInCircle',
    color: "primary",
    fill: true,
    iconSide: "left",
    onClick: () => setCreateModalOpen(true)
  }, "New"), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: 'question',
    color: "primary",
    iconSide: "left",
    href: "/"
  }, "Learn more")];
  const onTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  const {
    pageOfItems,
    totalItemCount
  } = findAgents(agents, pageIndex, pageSize, sortField, sortDirection);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 20, 50]
  };
  const resultsCount = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "workchatApp.assistants.list.resultsCountLabel",
    defaultMessage: "Showing {start}-{end} of {total}",
    values: {
      start: /*#__PURE__*/_react.default.createElement("strong", null, pageSize * pageIndex + 1),
      end: /*#__PURE__*/_react.default.createElement("strong", null, pageSize * pageIndex + pageSize),
      total: totalItemCount
    }
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "workChatAssistantsListPage"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: _i18n.i18n.translate('workchatApp.assistants.pageTitle', {
      defaultMessage: 'Assistants'
    }),
    description: _i18n.i18n.translate('workchatApp.assistants.pageDescription', {
      defaultMessage: 'An assistant is an AI helper built around your data. It can search, summarize, and take action using your connected integrations. You can manage or create assistants from here.'
    }),
    rightSideItems: headerButtons
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, resultsCount), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: pageOfItems,
    sorting: sorting,
    onChange: onTableChange,
    pagination: pagination
  }), createModalOpen && /*#__PURE__*/_react.default.createElement(_assistant_create_modal.CreateNewAssistantModal, {
    onClose: () => setCreateModalOpen(false)
  })));
};
exports.AssistantListView = AssistantListView;