"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantView = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../app_paths");
var _assistant_details = require("./assistant_details");
var _assistant_workflow = require("./assistant_workflow");
var _use_agent = require("../../../hooks/use_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantView = ({
  agentId,
  selectedTab
}) => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    agent
  } = (0, _use_agent.useAgent)({
    agentId
  });
  const tabs = [{
    label: _i18n.i18n.translate('workchatApp.assistant.tabs.overviewTitle', {
      defaultMessage: 'Overview'
    }),
    id: 'details',
    onClick: () => navigateToWorkchatUrl(_app_paths.appPaths.assistants.edit({
      agentId
    }))
  }, {
    label: _i18n.i18n.translate('workchatApp.assistant.tabs.workflowTitle', {
      defaultMessage: 'Workflows'
    }),
    id: 'workflow',
    onClick: () => navigateToWorkchatUrl(_app_paths.appPaths.assistants.workflow({
      agentId
    }))
  }];
  const headerButtons = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'newChat',
    color: "primary",
    fill: true,
    iconSide: "left",
    onClick: () => navigateToWorkchatUrl(_app_paths.appPaths.chat.new({
      agentId
    }))
  }, "New conversation"), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: 'question',
    color: "primary",
    iconSide: "left",
    href: "/"
  }, "Learn more")];
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "workChatEditAssistantPage"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: agent === null || agent === void 0 ? void 0 : agent.name,
    rightSideItems: headerButtons,
    tabs: tabs.map(tab => {
      return {
        ...tab,
        isSelected: tab.id === selectedTab
      };
    })
  }), selectedTab === 'details' && /*#__PURE__*/_react.default.createElement(_assistant_details.AssistantDetails, {
    agentId: agentId
  }), selectedTab === 'workflow' && /*#__PURE__*/_react.default.createElement(_assistant_workflow.AssistantWorkflow, {
    agentId: agentId
  }));
};
exports.AssistantView = AssistantView;