"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_agent_edition = require("../../../hooks/use_agent_edition");
var _i18n2 = require("../i18n");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditPrompt = ({
  onClose,
  onSaveSuccess,
  agentId
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    state,
    submit,
    isSubmitting
  } = (0, _use_agent_edition.useAgentEdition)({
    agentId,
    onSaveSuccess: () => {
      notifications.toasts.addSuccess(_i18n.i18n.translate('workchatApp.assistants.editPromptModal.saveSuccessMessage', {
        defaultMessage: 'Assistant updated successfully'
      }));
      onSaveSuccess();
      onClose();
    }
  });
  const {
    control,
    handleSubmit,
    watch,
    setValue
  } = (0, _reactHookForm.useForm)({
    values: state
  });
  const useCase = watch('useCase');
  (0, _react.useEffect)(() => {
    if (useCase && useCase !== 'custom') {
      const selectedUseCase = _constants.ASSISTANT_USE_CASES.find(uc => uc.value === useCase);
      if (selectedUseCase && selectedUseCase.prompt) {
        setValue('systemPrompt', selectedUseCase.prompt);
      }
    }
  }, [useCase, setValue]);
  const handlePromptChange = e => {
    const newPrompt = e.target.value;
    setValue('systemPrompt', newPrompt);
    if (useCase !== 'custom') {
      setValue('useCase', 'custom');
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    style: {
      width: 800
    },
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('workchatApp.assistants.editPromptModal.title', {
    defaultMessage: 'Edit prompt'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSubmit(data => submit(data)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "useCase",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editPromptModal.useCaseLabel', {
        defaultMessage: 'Use case'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
      "data-test-subj": "assistantUseCaseSelect",
      options: _constants.ASSISTANT_USE_CASES.map(({
        label,
        value,
        description
      }) => ({
        inputDisplay: label,
        value,
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, label), !!description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, description))
      }))
    }, field, {
      valueOfSelected: field.value,
      hasDividers: true,
      fullWidth: true
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "systemPrompt",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editPromptModal.promptLabel', {
        defaultMessage: 'Prompt'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "assistantPromptTextArea"
    }, field, {
      onChange: handlePromptChange,
      fullWidth: true,
      rows: 8
    })))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, _i18n2.assistantLabels.editView.cancelButtonLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "savePromptButton",
    fill: true,
    onClick: handleSubmit(data => submit(data)),
    isLoading: isSubmitting
  }, _i18n2.assistantLabels.editView.saveButtonLabel)));
};
exports.EditPrompt = EditPrompt;