"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditAssistantBasicInfo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_agent_edition = require("../../../hooks/use_agent_edition");
var _i18n2 = require("../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AVATAR_COLORS = (0, _eui.euiPaletteColorBlind)();
const EditAssistantBasicInfo = ({
  onClose,
  agentId,
  onSaveSuccess
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    state,
    submit,
    isSubmitting
  } = (0, _use_agent_edition.useAgentEdition)({
    agentId,
    onSaveSuccess: () => {
      notifications.toasts.addSuccess(_i18n.i18n.translate('workchatApp.assistants.editBasicsModal.saveSuccessMessage', {
        defaultMessage: 'Assistant updated successfully'
      }));
      onSaveSuccess();
      onClose();
    }
  });
  const {
    control,
    handleSubmit,
    watch
  } = (0, _reactHookForm.useForm)({
    values: state
  });

  // Get form values for the avatar preview
  const name = watch('name');
  const avatarCustomText = watch('avatarCustomText');
  const avatarColor = watch('avatarColor');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    style: {
      width: 800
    },
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.title', {
    defaultMessage: 'Edit Assistant Basics'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSubmit(data => submit(data)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.identificationSection', {
    defaultMessage: 'Identification'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "name",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.nameLabel', {
        defaultMessage: 'Name'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "assistantNameInput"
    }, field, {
      fullWidth: true
    })))
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "description",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.descriptionLabel', {
        defaultMessage: 'Description'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "assistantDescriptionInput"
    }, field, {
      fullWidth: true,
      rows: 6
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, null, _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.descriptionHelpText', {
    defaultMessage: 'Describe what this assistant is going to be used for.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.avatarSection', {
    defaultMessage: 'Avatar'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    initials: avatarCustomText,
    name: name,
    color: avatarColor,
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "avatarColor",
    control: control,
    render: ({
      field: {
        onChange,
        value
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.colorLabel', {
        defaultMessage: 'Color'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      "data-test-subj": "assistantAvatarColorPicker",
      onChange: onChange,
      color: value,
      swatches: AVATAR_COLORS
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "avatarCustomText",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.textLabel', {
        defaultMessage: 'Custom Text'
      }),
      helpText: _i18n.i18n.translate('workchatApp.assistants.editBasicsModal.emojiHelpText', {
        defaultMessage: 'Press CTRL + CMD + Space for emojis'
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "assistantAvatarTextField"
    }, field, {
      fullWidth: true
    })))
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, _i18n2.assistantLabels.editView.cancelButtonLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saveBasicInfoButton",
    fill: true,
    onClick: handleSubmit(data => submit(data)),
    isLoading: isSubmitting
  }, _i18n2.assistantLabels.editView.saveButtonLabel)));
};
exports.EditAssistantBasicInfo = EditAssistantBasicInfo;