"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isChatError = exports.createChatError = exports.ChatError = void 0;
var _sseUtils = require("@kbn/sse-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents an error that can be thrown by the chat API.
 */
class ChatError extends _sseUtils.ServerSentEventError {
  constructor(code, message, meta = {}) {
    super(code, message, meta);
  }
}
exports.ChatError = ChatError;
const isChatError = error => {
  return error instanceof ChatError;
};
exports.isChatError = isChatError;
const createChatError = (code, message, meta = {}) => {
  return new ChatError(code, message, meta);
};
exports.createChatError = createChatError;