"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolResultFactory = exports.isContentResultTransportFormat = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isContentResultTransportFormat = content => {
  return content.type === 'text' && content.contentItemType === 'content' && typeof content.text === 'string' && content.reference != null;
};

/**
 * Utility factory to generate MCP call tool results
 */
exports.isContentResultTransportFormat = isContentResultTransportFormat;
const toolResultFactory = exports.toolResultFactory = {
  contentList: contents => {
    return {
      content: contents.map(content => {
        return {
          type: 'text',
          reference: content.reference,
          text: JSON.stringify(content.content),
          contentItemType: 'content'
        };
      })
    };
  },
  /**
   * Generates a plain text tool response
   */
  text: text => {
    return {
      content: [{
        type: 'text',
        text
      }]
    };
  },
  /**
   * Generates an error tool response
   */
  error: message => {
    return {
      content: [{
        type: 'text',
        text: `Error during tool execution: ${message}`
      }],
      isError: true
    };
  }
};