"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SalesforceTool = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bold = (0, _css.css)`
  font-weight: bold;
`;
const italic = (0, _css.css)`
  font-style: italic;
`;
const SalesforceTool = ({
  toolCall,
  toolResult
}) => {
  const toolNode = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: bold,
    color: "success"
  }, toolCall.toolName);
  const argsNode = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: italic,
    color: "accent"
  }, JSON.stringify(toolCall.args));
  if (toolResult) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.workchatApp.wci_salesforce.chat.toolCall.calledToolLabel",
      defaultMessage: "called Salesforce {tool} with arguments {args}",
      values: {
        tool: toolNode,
        args: argsNode
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.workchatApp.wci_salesforce.chat.toolCall.callingToolLabel",
      defaultMessage: "called Salesforce {tool} with arguments {args}",
      values: {
        tool: toolNode,
        args: argsNode
      }
    }));
  }
};
exports.SalesforceTool = SalesforceTool;