"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSourceConfigurationForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _use_generate_schema = require("../hooks/use_generate_schema");
var _use_index_name_autocomplete = require("../hooks/use_index_name_autocomplete");
var _i18n = require("./i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexSourceConfigurationForm = ({
  form
}) => {
  const {
    control,
    setValue
  } = form;
  const filterFieldsArray = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'configuration.fields.filterFields'
  });
  const [query, setQuery] = (0, _react.useState)('');
  const contextFieldsArray = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'configuration.fields.contextFields'
  });
  const fieldTypeOptions = [{
    value: 'keyword',
    text: 'Keyword'
  }, {
    value: 'text',
    text: 'Text'
  }, {
    value: 'date',
    text: 'Date'
  }, {
    value: 'number',
    text: 'Number'
  }, {
    value: 'boolean',
    text: 'Boolean'
  }];
  const {
    generateSchema
  } = (0, _use_generate_schema.useGenerateSchema)();
  const {
    isLoading,
    data
  } = (0, _use_index_name_autocomplete.useIndexNameAutocomplete)({
    query
  });
  const onSearchChange = searchValue => {
    setQuery(searchValue);
  };
  const onSchemaGenerated = (0, _react.useCallback)(definition => {
    setValue('configuration.description', definition.description);
    setValue('configuration.fields.filterFields', definition.filterFields.map(field => {
      return {
        field: field.field,
        type: field.type,
        description: field.description,
        getValues: field.asEnum
      };
    }));
    const queryClauses = definition.queryFields.map(field => {
      if (field.type === 'semantic_text') {
        return {
          semantic: {
            field: field.field,
            query: '{query}'
          }
        };
      } else {
        return {
          match: {
            [field.field]: '{query}'
          }
        };
      }
    });
    const queryTemplate = {
      bool: {
        should: queryClauses
      }
    };
    setValue('configuration.queryTemplate', JSON.stringify(queryTemplate, undefined, 2));
    setValue('configuration.fields.contextFields', definition.contentFields.map(field => {
      return {
        field: field.field,
        description: '',
        type: field.type === 'semantic_text' ? 'semantic' : undefined
      };
    }));
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.translations.indexSourceConfiguration.title),
    description: _i18n.translations.indexSourceConfiguration.description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.index.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.index",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewIndex",
      placeholder: _i18n.translations.indexSourceConfiguration.index.placeholder
    }, field, {
      isLoading: isLoading,
      selectedOptions: field.value ? [{
        label: field.value,
        key: field.value
      }] : undefined,
      singleSelection: {
        asPlainText: true
      },
      options: data.map(option => ({
        label: option,
        key: option
      })),
      onChange: selected => {
        const index = selected.length > 0 ? selected[0].key : '';
        field.onChange(index);
      },
      fullWidth: true,
      onSearchChange: onSearchChange,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "gear",
        onClick: () => {
          if (!field.value) return;
          generateSchema({
            indexName: field.value
          }, {
            onSuccess: onSchemaGenerated
          });
        }
      }, _i18n.translations.indexSourceConfiguration.index.generateConfig)
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.toolDescription.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.description",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewDescription",
      placeholder: _i18n.translations.indexSourceConfiguration.toolDescription.placeholder,
      rows: 3
    }, field))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.queryTemplate.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.queryTemplate",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewQueryTemplate",
      placeholder: _i18n.translations.indexSourceConfiguration.queryTemplate.placeholder,
      rows: 6
    }, field))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.translations.indexSourceConfiguration.filterFields.title),
    description: _i18n.translations.indexSourceConfiguration.filterFields.description
  }, filterFieldsArray.fields.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.translations.indexSourceConfiguration.filterFields.noFields.title,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.translations.indexSourceConfiguration.filterFields.noFields.description))) : filterFieldsArray.fields.map((filterField, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    key: filterField.id,
    css: {
      marginBottom: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.filterFields.fieldName
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.filterFields.${index}.field`,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      placeholder: _i18n.translations.indexSourceConfiguration.filterFields.fieldName
    }, field))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.filterFields.fieldType.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.filterFields.${index}.type`,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      options: fieldTypeOptions
    }, field))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.filterFields.getValues.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.filterFields.${index}.getValues`,
    control: control,
    render: ({
      field: {
        onChange,
        value,
        ...rest
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
      label: "",
      checked: value,
      onChange: e => onChange(e.target.checked)
    }, rest))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": "Remove field",
    onClick: () => filterFieldsArray.remove(index)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.filterFields.fieldDescription.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.filterFields.${index}.description`,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      placeholder: _i18n.translations.indexSourceConfiguration.filterFields.fieldDescription.placeholder
    }, field))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "plusInCircle",
    onClick: () => filterFieldsArray.append({
      field: '',
      type: 'keyword',
      getValues: true,
      description: ''
    })
  }, _i18n.translations.indexSourceConfiguration.filterFields.addField))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.translations.indexSourceConfiguration.contextFields.title),
    description: _i18n.translations.indexSourceConfiguration.contextFields.description
  }, contextFieldsArray.fields.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.translations.indexSourceConfiguration.contextFields.noFields.title,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.translations.indexSourceConfiguration.contextFields.noFields.description))) : contextFieldsArray.fields.map((contextField, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    key: contextField.id,
    css: {
      marginBottom: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.contextFields.fieldName
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.contextFields.${index}.field`,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      placeholder: _i18n.translations.indexSourceConfiguration.contextFields.fieldName
    }, field))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.translations.indexSourceConfiguration.contextFields.semantic.label
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `configuration.fields.contextFields.${index}.type`,
    control: control,
    render: ({
      field: {
        onChange,
        value,
        ...rest
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
      label: "",
      checked: value === 'semantic',
      onChange: e => onChange(e.target.checked ? 'semantic' : undefined)
    }, rest))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": "Remove field",
    onClick: () => contextFieldsArray.remove(index)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "plusInCircle",
    onClick: () => contextFieldsArray.append({
      field: '',
      description: ''
    })
  }, _i18n.translations.indexSourceConfiguration.contextFields.addField))));
};
exports.IndexSourceConfigurationForm = IndexSourceConfigurationForm;