"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalServerConfigurationForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalServerConfigurationForm = ({
  form
}) => {
  const {
    control
  } = form;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, "External Server Configuration"),
    description: "Configure the external server details"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "URL",
    helpText: "The URL of the external server"
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.url",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "workchatExternalServerUrl",
      placeholder: "https://example.com/api"
    }, field))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Description",
    helpText: "Description of the external server"
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.description",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      "data-test-subj": "workchatExternalServerDescription",
      placeholder: "Describe the external server"
    }, field))
  })));
};
exports.ExternalServerConfigurationForm = ExternalServerConfigurationForm;