"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLeafFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLeafFields = ({
  mappings
}) => {
  var _mappings$properties;
  const properties = (_mappings$properties = mappings.properties) !== null && _mappings$properties !== void 0 ? _mappings$properties : {};
  function extractFields(obj, prefix = '') {
    let fields = [];
    for (const [key, value] of Object.entries(obj)) {
      const fieldPath = prefix ? `${prefix}.${key}` : key;
      if (value.type) {
        // If it's a leaf field, add it
        fields.push({
          type: value.type,
          path: fieldPath
        });
      } else if (value.properties) {
        // If it's an object, go deeper
        fields = fields.concat(extractFields(value.properties, fieldPath));
      }
    }
    return fields;
  }
  return extractFields(properties);
};
exports.getLeafFields = getLeafFields;