"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildSchema = void 0;
var _build_index_schema = require("./workflows/build_index_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildSchema = async ({
  indexName,
  esClient,
  logger,
  chatModel
}) => {
  const graph = await (0, _build_index_schema.createSchemaGraph)({
    chatModel,
    esClient,
    logger
  });
  const output = await graph.invoke({
    indexName
  });
  return output.generatedDefinition;
};
exports.buildSchema = buildSchema;