"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebhookAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WebhookAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const defaultJson = JSON.stringify({
      message: 'Watch [{{ctx.metadata.name}}] has exceeded the threshold'
    }, null, 2);
    this.body = (0, _lodash.get)(props, 'body', props.ignoreDefaults ? null : defaultJson);
    this.method = (0, _lodash.get)(props, 'method');
    this.host = (0, _lodash.get)(props, 'host');
    this.port = (0, _lodash.get)(props, 'port');
    this.scheme = (0, _lodash.get)(props, 'scheme', 'http');
    this.path = (0, _lodash.get)(props, 'path');
    this.username = (0, _lodash.get)(props, 'username');
    this.password = (0, _lodash.get)(props, 'password');
    this.contentType = (0, _lodash.get)(props, 'contentType');
    this.fullPath = `${this.host}:${this.port}${this.path ? '/' + this.path : ''}`;
  }
  validate() {
    const errors = {
      host: [],
      port: [],
      body: [],
      username: [],
      password: []
    };
    if (!this.host) {
      errors.host.push(_i18n.i18n.translate('xpack.watcher.watchActions.webhook.hostIsRequiredValidationMessage', {
        defaultMessage: 'Webhook host is required.'
      }));
    }
    if (!this.port) {
      errors.port.push(_i18n.i18n.translate('xpack.watcher.watchActions.webhook.portIsRequiredValidationMessage', {
        defaultMessage: 'Webhook port is required.'
      }));
    }
    if (this.contentType === 'application/json' && typeof this.body === 'string' && this.body !== '') {
      const invalidJsonMessage = _i18n.i18n.translate('xpack.watcher.watchActions.webhook.invalidJsonValidationMessage', {
        defaultMessage: 'Invalid JSON'
      });
      try {
        const parsedJson = JSON.parse(this.body);
        if (parsedJson && typeof parsedJson !== 'object') {
          errors.body.push(invalidJsonMessage);
        }
      } catch (e) {
        errors.body.push(invalidJsonMessage);
      }
    }

    // Password is required if username specified
    if (this.username && !this.password) {
      errors.password.push(_i18n.i18n.translate('xpack.watcher.watchActions.webhook.passwordIsRequiredIfUsernameValidationMessage', {
        defaultMessage: 'Password is required.'
      }));
    }

    // Username is required if password is specified
    if (this.password && !this.username) {
      errors.username.push(_i18n.i18n.translate('xpack.watcher.watchActions.webhook.usernameIsRequiredIfPasswordValidationMessage', {
        defaultMessage: 'Username is required.'
      }));
    }
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      method: this.method,
      host: this.host,
      port: this.port,
      scheme: this.scheme,
      path: this.path,
      body: this.body,
      username: this.username,
      password: this.password,
      webhook: {
        host: this.host,
        port: this.port
      }
    });
    return result;
  }
  get simulateMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.webhookAction.simulateMessage', {
      defaultMessage: 'Sample request sent to {fullPath}',
      values: {
        fullPath: this.fullPath
      }
    });
  }
  get simulateFailMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.webhookAction.simulateFailMessage', {
      defaultMessage: 'Failed to send request to {fullPath}.',
      values: {
        fullPath: this.fullPath
      }
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new WebhookAction(upstreamAction);
  }
}
exports.WebhookAction = WebhookAction;
(0, _defineProperty2.default)(WebhookAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.webhookAction.typeName', {
  defaultMessage: 'Webhook'
}));
(0, _defineProperty2.default)(WebhookAction, "iconClass", 'logoWebhook');
(0, _defineProperty2.default)(WebhookAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.webhookAction.selectMessageText', {
  defaultMessage: 'Send a request to a web service.'
}));
(0, _defineProperty2.default)(WebhookAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.webhookAction.simulateButtonLabel', {
  defaultMessage: 'Send request'
}));