"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridPanel = GridPanel;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function GridPanel({
  stateParams,
  setValue
}) {
  var _stateParams$grid$val;
  const setGrid = (0, _react.useCallback)((paramName, value) => setValue('grid', {
    ...stateParams.grid,
    [paramName]: value
  }), [stateParams.grid, setValue]);
  const options = (0, _react.useMemo)(() => [...stateParams.valueAxes.map(({
    id,
    name
  }) => ({
    text: name,
    value: id
  })), {
    text: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.dontShowLabel', {
      defaultMessage: "Don't show"
    }),
    value: ''
  }], [stateParams.valueAxes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.gridAxis.gridText",
    defaultMessage: "Grid"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.xAxisLinesLabel', {
      defaultMessage: 'Show X-axis lines'
    }),
    paramName: "categoryLines",
    value: stateParams.grid.categoryLines,
    setValue: setGrid,
    "data-test-subj": "showCategoryLines"
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: "gridAxis",
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.yAxisLinesLabel', {
      defaultMessage: 'Y-axis lines'
    }),
    options: options,
    paramName: "valueAxis",
    value: (_stateParams$grid$val = stateParams.grid.valueAxis) !== null && _stateParams$grid$val !== void 0 ? _stateParams$grid$val : '',
    setValue: setGrid
  }));
}