"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/ui-actions-plugin/public");
var _services = require("./services");
var _vega_fn = require("./vega_fn");
var _vega_type = require("./vega_type");
var _vega_inspector = require("./vega_inspector");
var _vega_vis_renderer = require("./vega_vis_renderer");
var _get_service_settings_lazy = require("./vega_view/vega_map_view/service_settings/get_service_settings_lazy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal */

/** @internal */

/** @internal */

/** @internal */
class VegaPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    inspector,
    data,
    expressions,
    visualizations
  }) {
    (0, _services.setInjectedVars)({
      enableExternalUrls: this.initializerContext.config.get().enableExternalUrls
    });
    const visualizationDependencies = {
      core,
      plugins: {
        data
      },
      getServiceSettings: _get_service_settings_lazy.getServiceSettingsLazy
    };
    inspector.registerView((0, _vega_inspector.getVegaInspectorView)({
      uiSettings: core.uiSettings
    }));
    expressions.registerFunction(() => (0, _vega_fn.createVegaFn)(visualizationDependencies));
    expressions.registerRenderer((0, _vega_vis_renderer.getVegaVisRenderer)(visualizationDependencies));
    visualizations.createBaseVisualization(_vega_type.vegaVisType);
  }
  start(core, deps) {
    (0, _services.setNotifications)(core.notifications);
    (0, _services.setData)(deps.data);
    (0, _services.setDataViews)(deps.dataViews);
    (0, _services.setDocLinks)(core.docLinks);
    (0, _services.setMapsEms)(deps.mapsEms);
    (0, _services.setThemeService)(core.theme);
    (0, _services.setUsageCollectionStart)(deps.usageCollection);
    deps.uiActions.registerActionAsync('addVegaPanelAction', async () => {
      const {
        getAddVegaPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_vega_panel_action')));
      return getAddVegaPanelAction(deps);
    });
    deps.uiActions.attachAction(_public.ADD_PANEL_TRIGGER, 'addVegaPanelAction');
    if (deps.uiActions.hasTrigger('ADD_CANVAS_ELEMENT_TRIGGER')) {
      // Because Canvas is not enabled in Serverless, this trigger might not be registered - only attach
      // the create action if the Canvas-specific trigger does indeed exist.
      deps.uiActions.attachAction('ADD_CANVAS_ELEMENT_TRIGGER', 'addVegaPanelAction');
    }
  }
}
exports.VegaPlugin = VegaPlugin;