"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormatterType = void 0;
var _enums = require("../../../../common/enums");
var _durations = require("./durations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getFormatterType = formatter => {
  if ([_enums.DATA_FORMATTERS.NUMBER, _enums.DATA_FORMATTERS.BYTES, _enums.DATA_FORMATTERS.PERCENT, _enums.DATA_FORMATTERS.DEFAULT].includes(formatter)) {
    return formatter;
  }
  return formatter && (0, _durations.isDuration)(formatter) ? _enums.DATA_FORMATTERS.DURATION : _enums.DATA_FORMATTERS.CUSTOM;
};
exports.getFormatterType = getFormatterType;