"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalUrlErrorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExternalUrlErrorModal = ({
  url,
  handleClose
}) => {
  const externalUrlErrorModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: handleClose,
    "aria-labelledby": externalUrlErrorModalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: externalUrlErrorModalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.headerTitle",
    defaultMessage: "Access to this external URL is not yet enabled"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.bodyMessage",
    defaultMessage: "Configure {externalUrlPolicy} in your {kibanaConfigFileName} to allow access to {url}.",
    values: {
      url: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning",
        component: "span"
      }, url),
      externalUrlPolicy: 'externalUrl.policy',
      kibanaConfigFileName: 'kibana.yml'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleClose,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.closeButtonLabel",
    defaultMessage: "Close"
  }))));
};
exports.ExternalUrlErrorModal = ExternalUrlErrorModal;