"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./table_visualization.scss");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/kibana-react-plugin/public");
var _table_vis_basic = require("./table_vis_basic");
var _table_vis_split = require("./table_vis_split");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TableVisualizationComponent = ({
  core,
  handlers,
  visData: {
    direction,
    table,
    tables
  },
  visConfig,
  renderComplete
}) => {
  (0, _react.useLayoutEffect)(() => {
    // Temporary solution: DataGrid should provide onRender callback
    setTimeout(() => {
      renderComplete();
    }, 300);
  }, [renderComplete]);
  const uiStateProps = (0, _utils.useUiState)(handlers.uiState);
  const className = (0, _classnames.default)('tbvChart', {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    tbvChart__splitColumns: direction === 'column'
  });
  return /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: core
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    "data-test-subj": "tbvChart"
  }, table ? /*#__PURE__*/_react.default.createElement(_table_vis_basic.TableVisBasic, {
    fireEvent: handlers.event,
    table: table,
    visConfig: visConfig,
    uiStateProps: uiStateProps
  }) : /*#__PURE__*/_react.default.createElement(_table_vis_split.TableVisSplit, {
    fireEvent: handlers.event,
    tables: tables,
    visConfig: visConfig,
    uiStateProps: uiStateProps,
    enforceMinWidth: direction === 'column'
  }))));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = TableVisualizationComponent;
module.exports = exports.default;