"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersParamEditor = FiltersParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/kibana-react-plugin/public");
var _filter = require("./filter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generateId = (0, _eui.htmlIdGenerator)();
function FiltersParamEditor({
  agg,
  value = [],
  setValue
}) {
  const [filters, setFilters] = (0, _react.useState)(() => value.map(filter => ({
    ...filter,
    id: generateId()
  })));
  (0, _useMount.default)(() => {
    // set parsed values into model after initialization
    setValue(filters.map(filter => (0, _lodash.omit)({
      ...filter,
      input: filter.input
    }, 'id')));
  });
  (0, _react.useEffect)(() => {
    // responsible for discarding changes
    if (value.length !== filters.length || value.some((filter, index) => !(0, _lodash.isEqual)(filter, (0, _lodash.omit)(filters[index], 'id')))) {
      setFilters(value.map(filter => ({
        ...filter,
        id: generateId()
      })));
    }
  }, [filters, value]);
  const updateFilters = updatedFilters => {
    // do not set internal id parameter into saved object
    setValue(updatedFilters.map(filter => (0, _lodash.omit)(filter, 'id')));
    setFilters(updatedFilters);
  };
  const {
    services
  } = (0, _public.useKibana)();
  const onAddFilter = () => updateFilters([...filters, {
    input: services.data.query.queryString.getDefaultQuery(),
    label: '',
    id: generateId()
  }]);
  const onRemoveFilter = id => updateFilters(filters.filter(filter => filter.id !== id));
  const onChangeValue = (id, query, label) => updateFilters(filters.map(filter => filter.id === id ? {
    ...filter,
    input: query,
    label
  } : filter));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), filters.map(({
    input,
    label,
    id
  }, arrayIndex) => /*#__PURE__*/_react.default.createElement(_filter.FilterRow, {
    key: id,
    id: id,
    arrayIndex: arrayIndex,
    customLabel: label,
    value: input,
    autoFocus: arrayIndex === filters.length - 1,
    disableRemove: arrayIndex === 0 && filters.length === 1,
    dataTestSubj: `visEditorFilterInput_${agg.id}_${arrayIndex}`,
    agg: agg,
    onChangeValue: onChangeValue,
    onRemoveFilter: onRemoveFilter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    fill: true,
    fullWidth: true,
    onClick: onAddFilter,
    size: "s",
    "data-test-subj": "visEditorAddFilterButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.filters.addFilterButtonLabel",
    defaultMessage: "Add filter"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}