"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldParamEditor = FieldParamEditor;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const label = _i18n.i18n.translate('visDefaultEditor.controls.field.fieldLabel', {
  defaultMessage: 'Field'
});
function FieldParamEditor({
  agg,
  aggParam,
  customError,
  customLabel,
  indexedFields = [],
  showValidation,
  value,
  setTouched,
  setValidity,
  setValue
}) {
  const [isDirty, setIsDirty] = (0, _react.useState)(false);
  const selectedOptions = value ? [{
    label: value.displayName,
    target: value,
    key: value.name
  }] : [];
  const onChange = options => {
    const selectedOption = (0, _lodash.get)(options, '0.target');
    if (!(aggParam.required && !selectedOption)) {
      setValue(selectedOption);
    }
    if (aggParam.onChange) {
      aggParam.onChange(agg);
    }
  };
  const errors = customError ? [customError] : [];
  let showErrorMessageImmediately = false;
  if (!indexedFields.length) {
    errors.push(_i18n.i18n.translate('visDefaultEditor.controls.field.noCompatibleFieldsDescription', {
      defaultMessage: 'The index pattern {indexPatternTitle} does not contain any of the following compatible field types: {fieldTypes}',
      values: {
        indexPatternTitle: agg.getIndexPattern && agg.getIndexPattern().title,
        fieldTypes: getFieldTypesString(agg)
      }
    }));
  }
  if (value && value.type === _public.KBN_FIELD_TYPES.MISSING) {
    errors.push(_i18n.i18n.translate('visDefaultEditor.controls.field.fieldIsNotExists', {
      defaultMessage: 'The field "{fieldParameter}" associated with this object no longer exists in the index pattern. Please use another field.',
      values: {
        fieldParameter: value.name
      }
    }));
    showErrorMessageImmediately = true;
  } else if (value && !getFieldTypes(agg).find(type => type === value.type || type === '*')) {
    errors.push(_i18n.i18n.translate('visDefaultEditor.controls.field.invalidFieldForAggregation', {
      defaultMessage: 'Saved field "{fieldParameter}" of index pattern "{indexPatternTitle}" is invalid for use with this aggregation. Please select a new field.',
      values: {
        fieldParameter: value === null || value === void 0 ? void 0 : value.name,
        indexPatternTitle: agg.getIndexPattern && agg.getIndexPattern().title
      }
    }));
    showErrorMessageImmediately = true;
  }
  const isValid = !!value && !errors.length && !isDirty;
  // we show an error message right away if there is no compatible fields
  const showErrorMessage = (showValidation || !indexedFields.length || showErrorMessageImmediately) && !isValid;
  (0, _utils.useValidation)(setValidity, isValid);
  (0, _useMount.default)(() => {
    // set field if only one available
    if (indexedFields.length !== 1) {
      return;
    }
    const indexedField = indexedFields[0];
    if (!('options' in indexedField)) {
      setValue(indexedField.target);
    } else if (indexedField.options.length === 1) {
      setValue(indexedField.options[0].target);
    }
  });
  const onSearchChange = (0, _react.useCallback)(searchValue => setIsDirty(Boolean(searchValue)), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: customLabel || label,
    isInvalid: showErrorMessage,
    fullWidth: true,
    error: errors,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    placeholder: _i18n.i18n.translate('visDefaultEditor.controls.field.selectFieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    options: indexedFields,
    isDisabled: !indexedFields.length,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    isInvalid: showErrorMessage,
    onChange: onChange,
    onBlur: setTouched,
    onSearchChange: onSearchChange,
    sortMatchesBy: "startsWith",
    "data-test-subj": "visDefaultEditorField",
    fullWidth: true
  }));
}
function getFieldTypesString(agg) {
  return (0, _utils.formatListAsProse)(getFieldTypes(agg), {
    inclusive: false
  });
}
function getFieldTypes(agg) {
  const param = (0, _lodash.get)(agg, 'type.params', []).find(p => p.name === 'field') || {};
  return (0, _utils.parseCommaSeparatedList)(param.filterFieldTypes || []);
}