"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedWildcards = SelectedWildcards;
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SelectedWildcards({
  indexPattern
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      searchTerm
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const updateSearchTerm = (0, _react.useCallback)(searchTermN => {
    const newQuery = {
      ...(0, _public.toQuery)(history.location.search),
      searchTerm: searchTermN || undefined
    };
    if (!searchTermN) {
      delete newQuery.searchTerm;
    }
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)(newQuery)
    };
    history.push(newLocation);
  }, [history]);
  return searchTerm ? /*#__PURE__*/React.createElement(_public2.FilterValueLabel, {
    dataView: indexPattern,
    removeFilter: () => {
      updateSearchTerm('');
    },
    invertFilter: ({
      negate
    }) => {},
    field: _elasticsearch_fieldnames.TRANSACTION_URL,
    value: searchTerm,
    negate: false,
    label: 'URL wildcard'
  }) : null;
}