"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storeUiReport = storeUiReport;
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _store_application_usage = require("./store_application_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function storeUiReport(internalRepository, usageCounters, report) {
  const uiCounters = report.uiCounter ? Object.entries(report.uiCounter) : [];
  const userAgents = report.userAgent ? Object.entries(report.userAgent) : [];
  const appUsages = report.application_usage ? Object.values(report.application_usage) : [];
  const momentTimestamp = (0, _moment.default)();
  const timestamp = momentTimestamp.toDate();
  return Promise.allSettled([
  // User Agent
  ...userAgents.map(async ([key, metric]) => {
    const {
      userAgent
    } = metric;
    const savedObjectId = `${key}:${userAgent}`;
    return await internalRepository.create('ui-metric', {
      count: 1
    }, {
      id: savedObjectId,
      overwrite: true,
      refresh: false
    });
  }),
  // Deprecated UI metrics, Use data from UI Counters.
  ...(0, _lodash.chain)(report.uiCounter).groupBy(e => `${e.appName}:${e.eventName}`).entries().map(([savedObjectId, metric]) => {
    return {
      savedObjectId,
      incrementBy: (0, _lodash.sumBy)(metric, 'total')
    };
  }).map(async ({
    savedObjectId,
    incrementBy
  }) => {
    return await internalRepository.incrementCounter('ui-metric', savedObjectId, [{
      fieldName: 'count',
      incrementBy
    }]);
  }).value(),
  // UI Counters
  ...uiCounters.map(async ([, metric]) => {
    var _usageCounters$getUsa;
    const {
      appName,
      eventName,
      total,
      type
    } = metric;
    const counter = (_usageCounters$getUsa = usageCounters.getUsageCounterByDomainId(appName)) !== null && _usageCounters$getUsa !== void 0 ? _usageCounters$getUsa : usageCounters.createUsageCounter(appName);
    counter.incrementCounter({
      counterName: eventName,
      counterType: type,
      incrementBy: total,
      source: 'ui'
    });
  }),
  // Application Usage
  (0, _store_application_usage.storeApplicationUsage)(internalRepository, appUsages, timestamp)]);
}