"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertMonitorStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _Either = require("fp-ts/Either");
var _selectors = require("../../../../state/selectors");
var _alert_monitor_status = require("../monitor_status_alert/alert_monitor_status");
var _actions = require("../../../../state/actions");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_snap_shot = require("./use_snap_shot");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  TYPE,
  TAGS,
  LOCATION,
  PORT
} = _constants.FILTER_FIELDS;
const AlertMonitorStatus = ({
  id,
  enabled,
  numTimes,
  setRuleParams,
  timerange,
  ruleParams,
  stackVersion
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    if (ruleParams.search) {
      dispatch((0, _actions.setSearchTextAction)(ruleParams.search));
    }
  }, [ruleParams, dispatch]);
  (0, _react.useEffect)(() => {
    if (!id && stackVersion && !ruleParams.stackVersion) {
      setRuleParams('stackVersion', stackVersion);
    }
  }, [ruleParams, id, stackVersion, setRuleParams]);
  const {
    count,
    loading
  } = (0, _use_snap_shot.useSnapShotCount)({
    query: ruleParams.search,
    filters: ruleParams.filters
  });
  const isOldAlert = _react.default.useMemo(() => Object.entries(ruleParams).length > 0 && !(0, _Either.isRight)(_runtime_types.AtomicStatusCheckParamsType.decode(ruleParams)) && !(0, _Either.isRight)(_runtime_types.GetMonitorAvailabilityParamsType.decode(ruleParams)), [ruleParams]);
  const selectedFilters = (0, _reactRedux.useSelector)(_selectors.selectedFiltersSelector);
  (0, _react.useEffect)(() => {
    if (!ruleParams.filters && selectedFilters !== null) {
      var _selectedFilters$port, _selectedFilters$loca, _selectedFilters$sche, _selectedFilters$tags;
      setRuleParams('filters', {
        [PORT]: (_selectedFilters$port = selectedFilters === null || selectedFilters === void 0 ? void 0 : selectedFilters.ports) !== null && _selectedFilters$port !== void 0 ? _selectedFilters$port : [],
        [LOCATION]: (_selectedFilters$loca = selectedFilters === null || selectedFilters === void 0 ? void 0 : selectedFilters.locations) !== null && _selectedFilters$loca !== void 0 ? _selectedFilters$loca : [],
        [TYPE]: (_selectedFilters$sche = selectedFilters === null || selectedFilters === void 0 ? void 0 : selectedFilters.schemes) !== null && _selectedFilters$sche !== void 0 ? _selectedFilters$sche : [],
        [TAGS]: (_selectedFilters$tags = selectedFilters === null || selectedFilters === void 0 ? void 0 : selectedFilters.tags) !== null && _selectedFilters$tags !== void 0 ? _selectedFilters$tags : []
      });
    }
  }, [ruleParams, setRuleParams, selectedFilters]);
  return /*#__PURE__*/_react.default.createElement(_alert_monitor_status.AlertMonitorStatusComponent, {
    ruleParams: ruleParams,
    enabled: enabled,
    isOldAlert: isOldAlert,
    numTimes: numTimes,
    setRuleParams: setRuleParams,
    snapshotCount: count.total,
    snapshotLoading: loading,
    timerange: timerange
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AlertMonitorStatus = AlertMonitorStatus;