"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DonutChartLegend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _donut_chart_legend_row = require("./donut_chart_legend_row");
var _translations = require("../../../../../common/translations/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendContainer = _styledComponents.default.div`
  max-width: 150px;
  min-width: 100px;
  @media (max-width: 767px) {
    min-width: 0px;
    max-width: 100px;
  }
`;
const DonutChartLegend = ({
  down,
  up
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const danger = theme.euiTheme.colors.danger;
  const gray = theme.euiTheme.colors.lightShade;
  return /*#__PURE__*/_react.default.createElement(LegendContainer, null, /*#__PURE__*/_react.default.createElement(_donut_chart_legend_row.DonutChartLegendRow, {
    color: danger,
    content: down,
    message: _translations.STATUS_DOWN_LABEL,
    "data-test-subj": 'xpack.synthetics.snapshot.donutChart.down'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_donut_chart_legend_row.DonutChartLegendRow, {
    color: gray,
    content: up,
    message: _translations.STATUS_UP_LABEL,
    "data-test-subj": 'xpack.synthetics.snapshot.donutChart.up'
  }));
};
exports.DonutChartLegend = DonutChartLegend;