"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsActionsCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  resolutionTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.resolutionTooltipLabel', {
    defaultMessage: 'Resolve this issue by upgrading or deleting a job model snapshot.'
  })
};
const MlSnapshotsActionsCell = ({
  openFlyout
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.resolutionTooltipLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openFlyout,
    "data-test-subj": 'deprecation-mlSnapshot'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "gear",
    size: "m",
    "aria-label": i18nTexts.resolutionTooltipLabel
  })));
};
exports.MlSnapshotsActionsCell = MlSnapshotsActionsCell;