"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateIndexModalStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _step_progress = require("../../../../../common/step_progress");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorCallout = ({
  reason
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "danger",
  title: "There was an error"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, reason)));

/**
 * In charge of rendering the result of the make read-only calls
 */
const UpdateIndexModalStep = ({
  action,
  closeModal,
  meta,
  updateIndexState,
  retry
}) => {
  const {
    indexName
  } = meta;
  const {
    status,
    failedBefore,
    reason
  } = updateIndexState;
  const title = action === 'makeReadonly' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.step.readonlyStepText",
    defaultMessage: "Setting {indexName} index to read-only.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexName)
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.step.unfreezeStepText",
    defaultMessage: "Unfreezing {indexName} index.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexName)
    }
  });
  const modalTitle = action === 'makeReadonly' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.step.readonlyStep.title",
    defaultMessage: "Setting index to read-only"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.step.unfreezeStep.title",
    defaultMessage: "Unfreezing index"
  });
  const steps = [{
    title,
    status,
    ...(reason && {
      children: /*#__PURE__*/_react.default.createElement(ErrorCallout, {
        reason
      })
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "updateIndexModalTitle",
    size: "m"
  }, modalTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "updateIndexProgress"
  }, /*#__PURE__*/_react.default.createElement("h3", null, (status === 'inProgress' || status === 'incomplete') && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.title.updateInProgressText",
    defaultMessage: "Upgrade in progress\u2026"
  }), status === 'complete' && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.title.updateCompleteText",
    defaultMessage: "Operation completed"
  }), status === 'failed' && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.checklist.title.updateFailedText",
    defaultMessage: "Operation failed"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_step_progress.StepProgress, {
    steps: steps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    color: "primary",
    "data-test-subj": "closeUpdateStepButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.closeButtonLabel",
    defaultMessage: "Close"
  })), status !== 'complete' && failedBefore && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: retry,
    isLoading: status === 'inProgress',
    disabled: status === 'inProgress',
    "data-test-subj": "retryUpdateStepButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.updateStep.retryButtonLabel",
    defaultMessage: "Retry"
  })))));
};
exports.UpdateIndexModalStep = UpdateIndexModalStep;