"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDurationFormat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monitoring_utils = require("../../../lib/monitoring_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleDurationFormat = exports.RuleDurationFormat = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    duration,
    allowZero = true
  } = props;
  const formattedDuration = (0, _react.useMemo)(() => {
    if (allowZero || typeof duration === 'number') {
      return (0, _monitoring_utils.getFormattedDuration)(duration);
    }
    return 'N/A';
  }, [duration, allowZero]);
  const formattedTooltip = (0, _react.useMemo)(() => {
    if (allowZero || typeof duration === 'number') {
      return (0, _monitoring_utils.getFormattedMilliseconds)(duration);
    }
    return 'N/A';
  }, [duration, allowZero]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "rule-duration-format-tooltip",
    content: formattedTooltip
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "rule-duration-format-value",
    tabIndex: 0
  }, formattedDuration));
});